<!doctype html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
        <link rel="stylesheet" type="text/css" href="http://localhost/bbb-urbanquillpublishing/libraries/style.css">
        <title>Ghostwriting Mentors |  Better Business Bureau &#174;Profile</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
      <![endif]-->
    </head>
    <body>
        <div class="top-header">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <ul class="list-unstyled list-inline text-right">
                            <li class="list-inline-item">
                                <a href="https://www.bbb.org/delaware/public/insights/apply">Get Accredited</a>
                            </li>
                            <li class="list-inline-item">
                                <a href="https://www.bbb.org/us/de/wilmington/news">News & Events</a>
                            </li>
                            <li class="list-inline-item">
                                <a href="http://www.bbb.org/delaware/login">Business Login</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <header>
            <div class="container">
                <div class="row">
                    <div class="col-md-2">
                        <a href="https://bbb.org">
                            <svg viewBox="0 0 267.34 369.6" aria-label="svg icon" role="/img" aria-hidden="true" class="Icon-sc-v0v23i-4 eFIrhi Image-sc-1saqq67-0 jIvhkC">
                                <path fill="currentColor" d="M185.12 231.48H43.87l-5.13 16.88h37.64l7.19 23.29h61.88l7.16-23.29h37.64l-5.13-16.88zm-118.2-94.86a33.38 33.38 0 0 0 7.43 46.63l33.8 24.56a8.37 8.37 0 0 1 1.86 11.69l5.09 3.68 17.86-24.68a33.18 33.18 0 0 0 6.37-19.54 33.78 33.78 0 0 0-.42-5.32 33.2 33.2 0 0 0-13.41-21.74l-33.8-24.56a8.3 8.3 0 0 1-3.35-5.45 8.78 8.78 0 0 1-.11-1.34 8.24 8.24 0 0 1 1.59-4.88l-5.08-3.69zm20.37-98.73a48.08 48.08 0 0 0-9.23 28.34 49.2 49.2 0 0 0 .61 7.71 48.13 48.13 0 0 0 19.41 31.56l42.49 30.77a25.8 25.8 0 0 1 10.4 16.93 26.4 26.4 0 0 1 .33 4.12 25.76 25.76 0 0 1-5 15.19l4.1 2.99 33.48-46.27A48.41 48.41 0 0 0 173.1 61.6l-51.3-37.29a14.94 14.94 0 0 1-3.3-20.86L114.4.5zM.5 285.75h38.7c9.53 0 17 2.62 21.79 7.38a19.11 19.11 0 0 1 5.71 14.17v.2c0 9.41-5 14.65-11 18 9.64 3.7 15.6 9.29 15.6 20.49v.24c0 15.24-12.38 22.86-31.2 22.86H.5zm34.77 33.7c8.1 0 13.22-2.62 13.22-8.81v-.24c0-5.48-4.29-8.57-12-8.57H18.36v17.62zm4.88 33.58c8.1 0 13-2.86 13-9v-.24c0-5.6-4.17-9-13.58-9H18.36v18.33zm39.17-67.28h38.7c9.53 0 17 2.62 21.79 7.38a19.13 19.13 0 0 1 5.69 14.17v.2c0 9.41-5 14.65-11 18 9.65 3.7 15.6 9.29 15.6 20.49v.24c0 15.24-12.38 22.86-31.2 22.86H79.32zm34.77 33.7c8.1 0 13.22-2.62 13.22-8.81v-.24c0-5.48-4.29-8.57-12-8.57H97.19v17.62zm4.88 33.58c8.1 0 13-2.86 13-9v-.24c0-5.6-4.17-9-13.57-9H97.19v18.33zm39.18-67.28h38.7c9.53 0 17 2.62 21.79 7.38a19.12 19.12 0 0 1 5.71 14.17v.2c0 9.41-5 14.65-11 18 9.65 3.7 15.6 9.29 15.6 20.49v.24c0 15.24-12.39 22.86-31.2 22.86h-39.6zm34.77 33.7c8.1 0 13.22-2.62 13.22-8.81v-.24c0-5.48-4.29-8.57-12-8.57h-18.1v17.62zm4.88 33.58c8.1 0 13-2.86 13-9v-.24c0-5.6-4.17-9-13.58-9h-21.2v18.33zm35.07-1.35v-.09a17 17 0 0 1 34-.09v.09a17 17 0 0 1-34 .09zm32-.09v-.09a15 15 0 1 0-30 .09v.09a15 15 0 1 0 30-.09zm-22-9.52h8a7.62 7.62 0 0 1 5.58 2 5.43 5.43 0 0 1 1.5 3.94v.09a5.61 5.61 0 0 1-3.9 5.58l4.41 6.47h-4.65l-3.85-5.82h-3.14v5.82h-4zm8 8.82c2 0 3.1-1.08 3.1-2.58v-.09c0-1.73-1.22-2.63-3.19-2.63h-3.9v5.3z"></path>
                            </svg>
                        </a>
                    </div>
                    <div class="col-md-10">
                        <div class="row">
                            <div class="col-md-6">
                                <span class="logo-text">
                                    <a href="https://bbb.org">Better Business Bureau®</a>
                                </span>
                            </div>
                            <div class="col-md-5">
                                <ul class="list-inline menu text-right mt-4">
                                    <li class="list-inline-item mr-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon text-size-20 text-blue-brand mr-1" focusable="false" height="1em" width="1em">
                                            <path d="M320 336c-22.608 0-43.387 7.819-59.79 20.895l-102.486-64.054a96.551 96.551 0 0 0 0-41.683l102.486-64.054C308.613 184.181 329.392 192 352 192c53.019 0 96-42.981 96-96S405.019 0 352 0s-96 42.981-96 96c0 7.158.79 14.13 2.276 20.841L155.79 180.895C139.387 167.819 118.608 160 96 160c-53.019 0-96 42.981-96 96s42.981 96 96 96c22.608 0 43.387-7.819 59.79-20.895l102.486 64.054A96.301 96.301 0 0 0 256 416c0 53.019 42.981 96 96 96s96-42.981 96-96-42.981-96-96-96z"></path>
                                        </svg>
                                        <a href="https://www.bbb.org/all/business-resources">Resources for Businesses
                              </a>
                                    </li>
                                    <li class="list-inline-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon text-size-30 text-blue-brand mr-1" focusable="false" height="1em" width="1em">
                                            <path d="M172.268 501.67C26.97 291.031 0 269.413 0 192 0 85.961 85.961 0 192 0s192 85.961 192 192c0 77.413-26.97 99.031-172.268 309.67-9.535 13.774-29.93 13.773-39.464 0zM192 272c44.183 0 80-35.817 80-80s-35.817-80-80-80-80 35.817-80 80 35.817 80 80 80z"></path>
                                        </svg>
                                        <a href="https://www.bbb.org/" id="showpopup">My BBB
                              </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-1">
                                <div class="dropdownmenu">
                                    <div class="toggle-menu">
                                        <div class="one"></div>
                                        <div class="two"></div>
                                        <div class="three"></div>
                                    </div>
                                    <div id="menu-links">
                                        <ul>
                                            <li>
                                                <a href="https://www.bbb.org/get-a-quote" class="bt-none">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                                        <path d="M288 256H96v64h192v-64zm89-151L279.1 7c-4.5-4.5-10.6-7-17-7H256v128h128v-6.1c0-6.3-2.5-12.4-7-16.9zm-153 31V0H24C10.7 0 0 10.7 0 24v464c0 13.3 10.7 24 24 24h336c13.3 0 24-10.7 24-24V160H248c-13.2 0-24-10.8-24-24zM64 72c0-4.42 3.58-8 8-8h80c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H72c-4.42 0-8-3.58-8-8V72zm0 64c0-4.42 3.58-8 8-8h80c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H72c-4.42 0-8-3.58-8-8v-16zm256 304c0 4.42-3.58 8-8 8h-80c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h80c4.42 0 8 3.58 8 8v16zm0-200v96c0 8.84-7.16 16-16 16H80c-8.84 0-16-7.16-16-16v-96c0-8.84 7.16-16 16-16h224c8.84 0 16 7.16 16 16z"></path>
                                                    </svg>
                                                    Get a Quote
                                       
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/leave-a-review">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                                        <path d="m402.6 83.2 90.2 90.2c3.8 3.8 3.8 10 0 13.8L274.4 405.6l-92.8 10.3c-12.4 1.4-22.9-9.1-21.5-21.5l10.3-92.8L388.8 83.2c3.8-3.8 10-3.8 13.8 0zm162-22.9-48.8-48.8c-15.2-15.2-39.9-15.2-55.2 0l-35.4 35.4c-3.8 3.8-3.8 10 0 13.8l90.2 90.2c3.8 3.8 10 3.8 13.8 0l35.4-35.4c15.2-15.3 15.2-40 0-55.2zM384 346.2V448H64V128h229.8c3.2 0 6.2-1.3 8.5-3.5l40-40c7.6-7.6 2.2-20.5-8.5-20.5H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V306.2c0-10.7-12.9-16-20.5-8.5l-40 40c-2.2 2.3-3.5 5.3-3.5 8.5z"></path>
                                                    </svg>
                                                    Start a Review
                                     
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/file-a-complaint">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                                        <path d="M349.565 98.783C295.978 98.783 251.721 64 184.348 64c-24.955 0-47.309 4.384-68.045 12.013a55.947 55.947 0 0 0 3.586-23.562C118.117 24.015 94.806 1.206 66.338.048 34.345-1.254 8 24.296 8 56c0 19.026 9.497 35.825 24 45.945V488c0 13.255 10.745 24 24 24h16c13.255 0 24-10.745 24-24v-94.4c28.311-12.064 63.582-22.122 114.435-22.122 53.588 0 97.844 34.783 165.217 34.783 48.169 0 86.667-16.294 122.505-40.858C506.84 359.452 512 349.571 512 339.045v-243.1c0-23.393-24.269-38.87-45.485-29.016-34.338 15.948-76.454 31.854-116.95 31.854z"></path>
                                                    </svg>
                                                    File a Complaint
                                     
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/scamtracker/us">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                                        <path d="M500 224h-30.364C455.724 130.325 381.675 56.276 288 42.364V12c0-6.627-5.373-12-12-12h-40c-6.627 0-12 5.373-12 12v30.364C130.325 56.276 56.276 130.325 42.364 224H12c-6.627 0-12 5.373-12 12v40c0 6.627 5.373 12 12 12h30.364C56.276 381.675 130.325 455.724 224 469.636V500c0 6.627 5.373 12 12 12h40c6.627 0 12-5.373 12-12v-30.364C381.675 455.724 455.724 381.675 469.636 288H500c6.627 0 12-5.373 12-12v-40c0-6.627-5.373-12-12-12zM288 404.634V364c0-6.627-5.373-12-12-12h-40c-6.627 0-12 5.373-12 12v40.634C165.826 392.232 119.783 346.243 107.366 288H148c6.627 0 12-5.373 12-12v-40c0-6.627-5.373-12-12-12h-40.634C119.768 165.826 165.757 119.783 224 107.366V148c0 6.627 5.373 12 12 12h40c6.627 0 12-5.373 12-12v-40.634C346.174 119.768 392.217 165.757 404.634 224H364c-6.627 0-12 5.373-12 12v40c0 6.627 5.373 12 12 12h40.634C392.232 346.174 346.243 392.217 288 404.634zM288 256c0 17.673-14.327 32-32 32s-32-14.327-32-32c0-17.673 14.327-32 32-32s32 14.327 32 32z"></path>
                                                    </svg>
                                                    BBB Scam Tracker
                                     
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/all/business-resources">Business Resources
                                     </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/get-accredited">Get Accredited
                                     </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/all/consumer-resources">For Consumers
                                     </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/all/employment">Careers
                                     </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/bbb-directory">Find Your Local BBB
                                     </a>
                                            </li>
                                            <li>
                                                <a href="https://www.bbb.org/scamtracker/delaware">BBB Scam Tracker
                                     </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="search-bar">
                                    <ul>
                                        <li>
                                            <input type="text" placeholder="businesses, charities, category">
                                        </li>
                                        <li>
                                            <input type="text" placeholder="city, state or zip">
                                        </li>
                                        <li>
                                            <input type="submit" value="Search">
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <section class="banner">
            <div class="container">
                <div class="row">
                    <div class="col-md-7">
                        <div class="breadcrumbs">
                            <ul class="list-inline">
                                <li class="list-inline-item mr-0">
                                    <a href="https://www.bbbaccredited.org/us/ca/los-angeles/profile/business-writer/ghostwriting-mentors-909765676">Home </a>
                                </li>
                                <li class="list-inline-item mr-0">
                                    <a href="https://www.bbbaccredited.org/us/ca/los-angeles/profile/business-writer/ghostwriting-mentors-909765676">US  </a>
                                </li>
                                <li class="list-inline-item mr-0">
                                    <a href="https://www.bbbaccredited.org/us/ca/los-angeles/profile/business-writer/ghostwriting-mentors-909765676">California </a>
                                </li>
                                <li class="list-inline-item mr-0">
                                    <a href="https://www.bbbaccredited.org/us/ca/los-angeles/profile/business-writer/ghostwriting-mentors-909765676">Los Angeles </a>
                                </li>
                                <li class="list-inline-item mr-0">Customer Reviews</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="styles__Styled-sc-1v4bojo-0 bJzQKd business-card__social-actions">
                            <ul class="list-inline text-right">
                                <li class="list-inline-item">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                        <path d="M352 320c-22.608 0-43.387 7.819-59.79 20.895l-102.486-64.054a96.551 96.551 0 0 0 0-41.683l102.486-64.054C308.613 184.181 329.392 192 352 192c53.019 0 96-42.981 96-96S405.019 0 352 0s-96 42.981-96 96c0 7.158.79 14.13 2.276 20.841L155.79 180.895C139.387 167.819 118.608 160 96 160c-53.019 0-96 42.981-96 96s42.981 96 96 96c22.608 0 43.387-7.819 59.79-20.895l102.486 64.054A96.301 96.301 0 0 0 256 416c0 53.019 42.981 96 96 96s96-42.981 96-96-42.981-96-96-96z"></path>
                                    </svg>
                                    <a role="button" class="Link__Styled-sc-1qsc7qd-0 cBokJD" href="#">
                                        <span>Share</span>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                        <path d="M448 192V77.25c0-8.49-3.37-16.62-9.37-22.63L393.37 9.37c-6-6-14.14-9.37-22.63-9.37H96C78.33 0 64 14.33 64 32v160c-35.35 0-64 28.65-64 64v112c0 8.84 7.16 16 16 16h48v96c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32v-96h48c8.84 0 16-7.16 16-16V256c0-35.35-28.65-64-64-64zm-64 256H128v-96h256v96zm0-224H128V64h192v48c0 8.84 7.16 16 16 16h48v96zm48 72c-13.25 0-24-10.75-24-24 0-13.26 10.75-24 24-24s24 10.74 24 24c0 13.25-10.75 24-24 24z"></path>
                                    </svg>
                                    <a role="button" class="Link__Styled-sc-1qsc7qd-0 cBokJD dtm-print" href="#">
                                        <span>Print</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="web-intro">
                    <div class="row">
                        <div class="col-md-3">
                            <img src="/img/AB-seal-horz.svg" alt="">
                        </div>
                        <div class="col-md-9 pl-md-0">
                            <h1>
                                <span>Business Profile</span>
                                Ghostwriting Mentors
                        <span>Ghost Writing</span>
                            </h1>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="profile-cta">
                                        <ul class="list-unstyled list-inline-item">
                                            <li class="list-inline-item">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon text-blue-brand" focusable="false" height="1em" width="1em">
                                                    <path d="M496 224h-50.88C431.61 143.66 368.34 80.39 288 66.88V16c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v50.88C143.66 80.39 80.39 143.66 66.88 224H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h50.88C80.39 368.34 143.66 431.61 224 445.12V496c0 8.84 7.16 16 16 16h32c8.84 0 16-7.16 16-16v-50.88c80.34-13.51 143.61-76.78 157.12-157.12H496c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16zM256 384c-70.7 0-128-57.31-128-128s57.3-128 128-128 128 57.31 128 128-57.3 128-128 128zm0-216c-48.6 0-88 39.4-88 88s39.4 88 88 88 88-39.4 88-88-39.4-88-88-88z"></path>
                                                </svg>
                                                <span>Multi Location Business</span>
                                            </li>
                                            <li class="list-inline-item ml-5">
                                                <a href="https://www.bbb.org/">Find Location</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-md-6 text-right mt-4">
                                    <a href="https://www.bbbaccredited.org/us/ca/los-angeles/profile/business-writer/ghostwriting-mentors-909765676/" class="back-profile">
                                        View Business profile
                                
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                            <path d="m224.3 273-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            <!-- <a href="https://www.bbbaccredited.org/us/ca/los-angeles/profile/business-writer/advance-ghostwriting-9082739282" class="btn-pm">View Business Profile</a> -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="reviews-all">
            <div class="container">
                <h6>20 Customer Reviews</h6>
                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-12 business-reviews business-reviews-all bg-none">
                                <!-- Year 2022 Start -->
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Kimberly Osorio</h4>
                                                <span class="date">11/18/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>ghostwritingmentors.com is a reliable service that deserves positive feedback. They managed to complete my final assignment promptly, I ordered. My author kept in touch with me throughout the writing process, providing feedback and reporting on the updated results as well
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Jason Ford</h4>
                                                <span class="date">11/16/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>I've attempted numerous times to produce an excellent paper, but I keep failing miserably. Guys, I appreciate your assistance tremendously. All of my demands and requirements were fulfilled, and now I am happy with the end result. I couldn't have done it without you.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Amelia Kelley</h4>
                                                <span class="date">11/15/2021
                                                </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>I'm thrilled that I came upon this service provider. I used to spend weeks looking for appropriate writing services, then I heard about this Ghostwriting Mentors service from a friend of mine. I've used to trust my friends, so I made use of this service, and glad I did. It's awesome, and I'm happy with their assistance and services.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- Year 2022 End -->
                                <!-- Year 2021 Start -->
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Theresa Minor</h4>
                                                <span class="date">11/13/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>I needed a novelist who could meet all of my book's standards. That's why I choose to use this service for this help. And no doubt they had clearly put in a lot of effort to offer me precisely what I needed. Now, I value my time and prefer to place my further books through this reliable website.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Cassandra Stiles</h4>
                                                <span class="date">11/12/2021
                                            </span>
                                                <br>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>Excellent writing service. I was blown away by these guys' ability to produce quality work on schedule. The charges are reasonable too, and they complete the work up to that same topic.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Iris Murphy</h4>
                                                <span class="date">11/10/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>I can't thank them enough as they have helped my brother in the past and now they've been helping me in writing my book, great service.. Just the timing could be a little better but so far so great!
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Ian Bing</h4>
                                                <span class="date">10/30/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <br>
                                                    <p>When I contacted them for my work I was a bit scared if they can handle my urgent work, they did a fantastic job with my project. I pray to God, He blesses this company.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Max Coopern</h4>
                                                <span class="date">09/20/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>My University projects became anxiety for me until the editors of advance ghost writing assisted me , would highly recommend their services
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Dennis Manning</h4>
                                                <span class="date">09/15/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>I'm determined to have my publishing done on time because of their fine writing skills and great team work
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Tyler Shelton</h4>
                                                <span class="date">09/13/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <br>
                                                    <p>Usually I don't go to these companies asking for their assistance but I was caught up with so much of work and home mess , I had to try if they can do what they keep advertising about, I must say they have completely changed my whole idea regarding ghost writing helpers, they were so professional and committed in making my project a success , will definitely ask them for my future work.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Darrell Yost</h4>
                                                <span class="date">09/10/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>Numerous factors contributed to my positive experience with this service. They are innovative, well-organized, knowledgeable, have a good reputation, and are pleasant to work with. I've never tried another service because I'm happy with this one.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Alba Stout</h4>
                                                <span class="date">09/07/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <br>
                                                    <p>I've hired Ghostwriting Mentors services two times and can say from my experience that I'm delighted with their expertise and dependability.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Toby Sutton</h4>
                                                <span class="date">09/05/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star "></span>
                                                    </div>
                                                    <p>I enjoy writing, but when it comes to preparing a research paper, I hesitate a lot. But after a recommendation from a buddy, I decided to give Ghostwriting Mentors a try. And, thankfully, with this company's assistance, I was able to obtain the well-researched paper I needed.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- Year 2021 End -->
                                <!-- Year 2019 Start -->
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Lisa Gabel</h4>
                                                <span class="date">09/04/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>I'm employing Ghostwriting Mentors services because I don't see another way to get out of my daily writing duties. I've always used their services since I trust their professionalism and quality of work.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <span class="date">09/02/2021
                                            </span>
                                                <h4 class="customer-name">Emily Scott</h4>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>Ghostwriting Mentors  is a fantastic writing service that has the skills I needed to turn an idea into a great storybook. They did an excellent job, and I have no issues. I'm delighted.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Robin Sigmund</h4>
                                                <span class="date">09/01/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star "></span>
                                                        <span class="fa fa-star "></span>
                                                    </div>
                                                    <p>THANK YOU FOR COMING UP WITH NEW DESIGN IDEAS ADVANCE GHOST WRITING TEAM! IT WAS A BIG HELP!
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Tameka C. McDaniel</h4>
                                                <span class="date">08/15/2021</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <br>
                                                    <p>You want your Infographics looking fantastic?? Go for Advance Ghost Writing!!!!!
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Richard Reynosa</h4>
                                                <span class="date">08/25/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                    </div>
                                                    <p>I'm a house wife with 4 kids , it's a very hectic 24/7 job, my husband is a businessman who works in research paper, I can't help my husband in his job even If I want to , My sister suggested me to try Ghostwriting Mentors and I tell you what It's been 4 years whenever my husband is stuck doing his research work , he doesn't worry but just ask for their help and they always have been really cooperative and helping.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Jose Jonah</h4>
                                                <span class="date">08/06/2021
                                            </span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>I paid them for my social media captions, It was worth it!
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="bx-white">
                                    <div class="comment-box inner-comment">
                                        <ul class="reviews-list">
                                            <li>
                                                <i>
                                                    <img src="/img/anon.svg" alt="">
                                                </i>
                                                <h4 class="customer-name">Alice Hebert</h4>
                                                <span class="date">04/11/2019</span>
                                                <div class="name-rating">
                                                    <div class="rating-pf">
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star checked"></span>
                                                        <span class="fa fa-star"></span>
                                                    </div>
                                                    <p>Kudos to them for understanding my story line and guiding me through. My Novel was one successful work done by them.
                                                </p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- Year 2018 Start -->
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 web-details web-details-sidebar">
                        <div class="row">
                            <div class="col-12">
                                <div class="bx-white review-section">
                                    <h3>Customer Review Ratin</h3>
                                    <div class="rating-pf">
                                        <svg class="full" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" aria-hidden="true" focusable="false" height="1em" width="1em">
                                            <path d="M259.3 17.8 194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z"></path>
                                        </svg>
                                        <svg class="full" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" aria-hidden="true" focusable="false" height="1em" width="1em">
                                            <path d="M259.3 17.8 194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z"></path>
                                        </svg>
                                        <svg class="full" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" aria-hidden="true" focusable="false" height="1em" width="1em">
                                            <path d="M259.3 17.8 194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z"></path>
                                        </svg>
                                        <svg class="full" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" aria-hidden="true" focusable="false" height="1em" width="1em">
                                            <path d="M259.3 17.8 194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z"></path>
                                        </svg>
                                        <svg class="half" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" aria-hidden="true" focusable="false" height="1em" width="1em">
                                            <path d="M528.1 171.5 382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6zM388.6 312.3l23.7 138.4L288 385.4l-124.3 65.3 23.7-138.4-100.6-98 139-20.2 62.2-126 62.2 126 139 20.2-100.6 98z"></path>
                                        </svg>
                                        <b>
                                            5<span>/4.8</span>
                                        </b>
                                        <p>Average of 20 Customer Reviews</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="bx-white cta-box inner-cta">
                                    <h3>Contact Informaion</h3>
                                    <ul>
                                        <li>
                                            <i>
                                                <svg viewBox="0 0 384 512" aria-label="svg icon" role="/img" aria-hidden="true" class="Icon-sc-v0v23i-4 eFIrhi">
                                                    <path fill="currentColor" d="M172.268 501.67C26.97 291.031 0 269.413 0 192 0 85.961 85.961 0 192 0s192 85.961 192 192c0 77.413-26.97 99.031-172.268 309.67-9.535 13.774-29.93 13.773-39.464 0zM192 272c44.183 0 80-35.817 80-80s-35.817-80-80-80-80 35.817-80 80 35.817 80 80 80z"></path>
                                                </svg>
                                            </i>
                                            2911 Turtle Creek Blvd. Suite 300, Dallas, TX, 75219
                                   
                                        </li>
                                        <li>
                                            <i>
                                                <svg viewBox="0 0 496 512" aria-label="svg icon" role="/img" aria-hidden="true" class="Icon-sc-v0v23i-4 jVDvPL">
                                                    <path fill="currentColor" d="M248 8C111.03 8 0 119.03 0 256s111.03 248 248 248 248-111.03 248-248S384.97 8 248 8zm82.29 357.6c-3.9 3.88-7.99 7.95-11.31 11.28-2.99 3-5.1 6.7-6.17 10.71-1.51 5.66-2.73 11.38-4.77 16.87l-17.39 46.85c-13.76 3-28 4.69-42.65 4.69v-27.38c1.69-12.62-7.64-36.26-22.63-51.25-6-6-9.37-14.14-9.37-22.63v-32.01c0-11.64-6.27-22.34-16.46-27.97-14.37-7.95-34.81-19.06-48.81-26.11-11.48-5.78-22.1-13.14-31.65-21.75l-.8-.72a114.792 114.792 0 0 1-18.06-20.74c-9.38-13.77-24.66-36.42-34.59-51.14 20.47-45.5 57.36-82.04 103.2-101.89l24.01 12.01C203.48 89.74 216 82.01 216 70.11v-11.3c7.99-1.29 16.12-2.11 24.39-2.42l28.3 28.3c6.25 6.25 6.25 16.38 0 22.63L264 112l-10.34 10.34c-3.12 3.12-3.12 8.19 0 11.31l4.69 4.69c3.12 3.12 3.12 8.19 0 11.31l-8 8a8.008 8.008 0 0 1-5.66 2.34h-8.99c-2.08 0-4.08.81-5.58 2.27l-9.92 9.65a8.008 8.008 0 0 0-1.58 9.31l15.59 31.19c2.66 5.32-1.21 11.58-7.15 11.58h-5.64c-1.93 0-3.79-.7-5.24-1.96l-9.28-8.06a16.017 16.017 0 0 0-15.55-3.1l-31.17 10.39a11.95 11.95 0 0 0-8.17 11.34c0 4.53 2.56 8.66 6.61 10.69l11.08 5.54c9.41 4.71 19.79 7.16 30.31 7.16s22.59 27.29 32 32h66.75c8.49 0 16.62 3.37 22.63 9.37l13.69 13.69a30.503 30.503 0 0 1 8.93 21.57 46.536 46.536 0 0 1-13.72 32.98zM417 274.25c-5.79-1.45-10.84-5-14.15-9.97l-17.98-26.97a23.97 23.97 0 0 1 0-26.62l19.59-29.38c2.32-3.47 5.5-6.29 9.24-8.15l12.98-6.49C440.2 193.59 448 223.87 448 256c0 8.67-.74 17.16-1.82 25.54L417 274.25z"></path>
                                                </svg>
                                            </i>
                                            <a href="http://www.ghostwritingmentors.com" class="text-underline">http://www.ghostwritingmentors.com</a>
                                        </li>
                                        <li>
                                            <i>
                                                <svg viewBox="0 0 512 512" aria-label="svg icon" role="/img" aria-hidden="true" class="Icon-sc-v0v23i-4 jVDvPL">
                                                    <path fill="currentColor" d="M493.4 24.6l-104-24c-11.3-2.6-22.9 3.3-27.5 13.9l-48 112c-4.2 9.8-1.4 21.3 6.9 28l60.6 49.6c-36 76.7-98.9 140.5-177.2 177.2l-49.6-60.6c-6.8-8.3-18.2-11.1-28-6.9l-112 48C3.9 366.5-2 378.1.6 389.4l24 104C27.1 504.2 36.7 512 48 512c256.1 0 464-207.5 464-464 0-11.2-7.7-20.9-18.6-23.4z"></path>
                                                </svg>
                                            </i>
                                            <a href="tel:(469) 902-7699 1">469-902-7699 </a>
                                        </li>
                                    </ul>
                                    <div class="getquote text-center">
                                        <p>Want a quote from this business?</p>
                                        <a href="javascript:;">Get a Quote</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="bx-white cta-box rating-box inner-rating no-height">
                                    <h3>BBB Rating &amp;Accreditation</h3>
                                    <img src="/img/AB-seal-horz.svg" alt="" class="mr-3">
                                    <span class="LetterGrade-sc-10acl6x-0 Graphics__LetterGradeRating-sc-jmqqvl-2 cohIwl dtm-rating business-rating-card__rating">
                                        A<span>+</span>
                                    </span>
                                    <ul>
                                        <li class="mb-0">
                                            <b>Accredited Since:</b>
                                            3/15/2011
                                        </li>
                                        <li>
                                            <b>Years in Business:</b>
                                            12
                                        </li>
                                    </ul>
                                    <p>Customer Reviews are not used in the calculation of BBB Rating</p>
                                    <a href="https://www.bbb.org/overview-of-bbb-ratings">Reasons for BBB Rating</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <section class="cotent-small">
                <div class="container">
                    <p>BBB Business Profiles may not be reproduced for sales or promotional purposes.</p>
                    <p>BBB Business Profiles are provided solely to assist you in exercising your own best judgment. BBB asks third parties who publish complaints, reviews and/or responses on this website to affirm that the information provided is accurate. However, BBB does not verify the accuracy of information provided by third parties, and does not guarantee the accuracy of any information in Business Profiles.</p>
                    <p>When considering complaint information, please take into account the company's size and volume of transactions, and understand that the nature of complaints and a firm's responses to them are often more important than the number of complaints.</p>
                    <p>BBB Business Profiles generally cover a three-year reporting period. BBB Business Profiles are subject to change at any time. If you choose to do business with this business, please let the business know that you contacted BBB for a BBB Business Profile.</p>
                    <p>As a matter of policy, BBB does not endorse any product, service or business.</p>
                </div>
            </section>
        </section>
        <footer>
            <div class="container">
                <div class="row">
                    <div class="col-md-2">
                        <img src="/img/BBB_US_Torch_sm.svg" alt="">
                    </div>
                    <div class="col-md-3">
                        <h6>
                            <a href="https://www.bbb.org/all/consumer-resources">For Consumers</a>
                        </h6>
                        <ul>
                            <ul class="LinkList-sc-wse2ux-0 kljpgC">
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/search" class="dtm-footer-link">Search for a Business</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/get-a-quote" class="dtm-footer-link">Get a Quote</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/leave-a-review" class="dtm-footer-link">Start a Review</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/file-a-complaint" class="dtm-footer-link">File a Complaint</a>
                                </li>
                                <li class="mb-0">
                                    <a href="//www.bbb.org/scamtracker/us" class="dtm-footer-link">BBB Scam Tracker</a>
                                </li>
                                <li class="mb-0">
                                    <a href="//www.bbb.org/autoline" class="dtm-footer-link">File an Auto Warranty Complaint</a>
                                </li>
                                <li class="mb-0">
                                    <a href="//www.bbb.org/all/bbbi/adtruth" class="dtm-footer-link">BBB Ad Truth</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://signup.e2ma.net/signup/1900156/1902645" target="_blank" class="dtm-footer-link">Sign up for Scam Alerts</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/frequently-asked-questions" class="dtm-footer-link">Frequently Asked Questions (FAQ)</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/all/consumer-hq" class="dtm-footer-link">Consumer HQ</a>
                                </li>
                            </ul>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <h6>
                            <a href="https://www.bbb.org/all/about-bbb" class="dtm-footer-link">About BBB®</a>
                        </h6>
                        <ul class="LinkList-sc-wse2ux-0 bvNpTS">
                            <ul class="LinkList-sc-wse2ux-0 kljpgC">
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/search" class="dtm-footer-link">Search Business Profiles</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/become-accredited" class="dtm-footer-link">Get Accredited</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://bbbprograms.org/programs/bbb-privacy-shield" target="_blank" class="dtm-footer-link">BBB EU Privacy Shield</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/get-listed" class="dtm-footer-link">Get Your Business Listed</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/partner-code-of-conduct" class="dtm-footer-link">Partner Code of Conduct</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/apply" class="dtm-footer-link">Apply for BBB Accreditation</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/all/your-business-hq" class="dtm-footer-link">Business HQ</a>
                                </li>
                            </ul>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <h6>About BBB®</h6>
                        <ul class="LinkList-sc-wse2ux-0 bvNpTS">
                            <ul class="LinkList-sc-wse2ux-0 kljpgC">
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/mission-and-vision" class="dtm-footer-link">Mission &amp;Vision</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/bbb-directory" class="dtm-footer-link">Directory of Local BBBs</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/local-bbb/international-association-of-better-business-bureaus" class="dtm-footer-link">International Association of Better Business Bureaus</a>
                                </li>
                                <li class="mb-0">
                                    <a href="//www.bbbmarketplacetrust.org" target="_blank" class="dtm-footer-link">BBB Institute for Marketplace Trust</a>
                                </li>
                                <li class="mb-0">
                                    <a href="//www.bbb.org/all/employment" target="_blank" class="dtm-footer-link">Careers</a>
                                </li>
                                <li class="mb-0">
                                    <a href="//give.org" target="_blank" class="dtm-footer-link">BBB Wise Giving Alliance (Give.org)</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbbprograms.org" target="_blank" class="dtm-footer-link">BBB National Programs</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.give.org" target="_blank" class="dtm-footer-link">Give.org</a>
                                </li>
                                <li class="mb-0">
                                    <a href="http://www.bbbmarketplacetrust.org" target="_blank" class="dtm-footer-link">BBB Institute for Marketplace Trust</a>
                                </li>
                                <li class="mb-0">
                                    <a href="https://www.bbb.org/partner-code-of-conduct" class="dtm-footer-link">BBB Business Partner Code</a>
                                </li>
                            </ul>
                            <ul class="social-icon listReset__UlListReset-sc-5fl4b5-1 SocialLinkList-sc-1a6uaxx-0 kEHjMu dFoEBZ cluster">
                                <li class="list-inline-item">
                                    <a href="https://www.facebook.com/BBBDelaware" target="_blank" class="styles__StyledLink-sc-uh1vd5-0 esDcYg dtm-footer-social-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                            <path d="M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h137.25V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.27c-30.81 0-40.42 19.12-40.42 38.73V256h68.78l-11 71.69h-57.78V480H400a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48z"></path>
                                        </svg>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="https://twitter.com/bbbdelaware" target="_blank" class="styles__StyledLink-sc-uh1vd5-0 esDcYg dtm-footer-social-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                            <path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-48.9 158.8c.2 2.8.2 5.7.2 8.5 0 86.7-66 186.6-186.6 186.6-37.2 0-71.7-10.8-100.7-29.4 5.3.6 10.4.8 15.8.8 30.7 0 58.9-10.4 81.4-28-28.8-.6-53-19.5-61.3-45.5 10.1 1.5 19.2 1.5 29.6-1.2-30-6.1-52.5-32.5-52.5-64.4v-.8c8.7 4.9 18.9 7.9 29.6 8.3a65.447 65.447 0 0 1-29.2-54.6c0-12.2 3.2-23.4 8.9-33.1 32.3 39.8 80.8 65.8 135.2 68.6-9.3-44.5 24-80.6 64-80.6 18.9 0 35.9 7.9 47.9 20.7 14.8-2.8 29-8.3 41.6-15.8-4.9 15.2-15.2 28-28.8 36.1 13.2-1.4 26-5.1 37.8-10.2-8.9 13.1-20.1 24.7-32.9 34z"></path>
                                        </svg>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="http://www.linkedin.com/groups/Better-Business-Bureau-Delaware-2079277" target="_blank" class="styles__StyledLink-sc-uh1vd5-0 esDcYg dtm-footer-social-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                            <path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"></path>
                                        </svg>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="https://www.youtube.com/channel/UCFMvpf1XMK5h_ls2NH2eaKQ" target="_blank" class="styles__StyledLink-sc-uh1vd5-0 esDcYg dtm-footer-social-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" aria-hidden="true" class="styles__StyledIcon-sc-4rsgi5-0 jJSpLP icon" focusable="false" height="1em" width="1em">
                                            <path d="m186.8 202.1 95.2 54.1-95.2 54.1V202.1zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-42 176.3s0-59.6-7.6-88.2c-4.2-15.8-16.5-28.2-32.2-32.4C337.9 128 224 128 224 128s-113.9 0-142.2 7.7c-15.7 4.2-28 16.6-32.2 32.4-7.6 28.5-7.6 88.2-7.6 88.2s0 59.6 7.6 88.2c4.2 15.8 16.5 27.7 32.2 31.9C110.1 384 224 384 224 384s113.9 0 142.2-7.7c15.7-4.2 28-16.1 32.2-31.9 7.6-28.5 7.6-88.1 7.6-88.1z"></path>
                                        </svg>
                                    </a>
                                </li>
                            </ul>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="Bottom-sc-1efyfgw-0">
                <div class="container">
                    <div class="row">
                        <div class="col-md-5 pr-md-0">
                            <ul class="LinkList-sc-wse2ux-0 bvNpTS">
                                <li>
                                    <a href="https://www.bbb.org/terms-of-use" title="Terms of Use" class="dtm-footer-link">Terms of Use</a>
                                </li>
                                <li>
                                    <a href="https://www.bbb.org/privacy-policy" title="Privacy Policy" class="dtm-footer-link">Privacy Policy</a>
                                </li>
                                <li>
                                    <a href="https://www.bbb.org/privacy-policy#your-ad-choices" title="Your Ad Choices" class="dtm-footer-link">Your Ad Choices</a>
                                </li>
                                <li>
                                    <a href="https://www.bbb.org/trademarks" title="Trademarks" class="dtm-footer-link">Trademarks</a>
                                </li>
                                <li>
                                    <a href="https://www.bbb.org/hyperlinking" title="Hyperlinking Policy" class="dtm-footer-link">Hyperlinking Policy</a>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-7">
                            <p>© 2022, International Association of Better Business Bureaus, Inc., separately incorporated Better Business Bureau organizations in the US, Canada and Mexico and BBB Institute for Marketplace Trust, Inc. All rights reserved. *In Canada, trademark(s) of the International Association of Better Business Bureaus, used under License.</p>
                        </div>
                    </div>
                </div>
        </footer>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
        <script>
            $("#showpopup").click(function() {
                $('#popup').css('display', 'block');
            });
            $("#closepoopup").click(function() {
                $('#popup').css('display', 'none');
            });
            $(".toggle-menu").click(function() {

                $(this).toggleClass("on");
                $("#menu-links").slideToggle();
            });
        </script>
    </body>
</html>
